package com.yd.user.service.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.user.feign.request.reltenantproject.ApiRelTenantProjectListPageRequest;
import com.yd.user.feign.request.reltenantproject.ApiRelTenantProjectSelectPageRequest;
import com.yd.user.feign.request.reltenantproject.QueryRelTenantProjectListRequest;
import com.yd.user.feign.response.reltenantproject.ApiRelTenantProjectListPageResponse;
import com.yd.user.feign.response.reltenantproject.ApiRelTenantProjectSelectPageResponse;
import com.yd.user.feign.response.reltenantproject.QueryRelTenantProjectListResponse;
import com.yd.user.service.dto.RelTenantProjectDto;
import com.yd.user.service.dto.SysTenantDto;
import com.yd.user.service.model.RelTenantProject;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yd.user.service.model.SysTenant;
import com.yd.user.service.model.SysUser;

import java.util.List;

/**
 * <p>
 * 租户-项目关系表（正常来说一对多，加关系表方便扩展） 服务类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
public interface IRelTenantProjectService extends IService<RelTenantProject> {

    IPage<ApiRelTenantProjectListPageResponse> page(Page<ApiRelTenantProjectListPageResponse> page,
                                                    ApiRelTenantProjectListPageRequest request);

    IPage<ApiRelTenantProjectSelectPageResponse> selectProjectPage(Page<ApiRelTenantProjectSelectPageResponse> page,
                                                                   ApiRelTenantProjectSelectPageRequest request);

    RelTenantProject queryOne(Long id);

    RelTenantProject queryOne(String tenantBizId, String projectBizId);

    List<RelTenantProject> queryList(RelTenantProjectDto dto);

    void delRelByProjectBizId(String projectBizId);

    void delRelByProjectBizIdNeTenantBizIdList(String projectBizId, List<String> tenantBizIdList);

    void delRelByTenantBizId(String tenantBizId);

    List<QueryRelTenantProjectListResponse> queryRelTenantProjectList(QueryRelTenantProjectListRequest request);
}
