package com.yd.user.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.user.feign.request.reltenantrole.ApiRelTenantRoleListPageRequest;
import com.yd.user.feign.request.reltenantrole.ApiRelTenantRoleSelectPageRequest;
import com.yd.user.feign.response.reltenantrole.ApiRelTenantRoleListPageResponse;
import com.yd.user.feign.response.reltenantrole.ApiRelTenantRoleSelectPageResponse;
import com.yd.user.service.dto.RelTenantRoleDto;
import com.yd.user.service.model.RelTenantProject;
import com.yd.user.service.model.RelTenantRole;
import com.yd.user.service.dao.RelTenantRoleMapper;
import com.yd.user.service.service.IRelTenantRoleService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 租户-角色关系表（正常来说一对多，加关系表方便扩展） 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
@Service
@Primary
public class RelTenantRoleServiceImpl extends ServiceImpl<RelTenantRoleMapper, RelTenantRole> implements IRelTenantRoleService {

    /**
     * 租户和角色关系分页查询
     * @param request
     * @return
     */
    @Override
    public IPage<ApiRelTenantRoleListPageResponse> page(Page<ApiRelTenantRoleListPageResponse> page, ApiRelTenantRoleListPageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 查询单个对象
     * @param id
     * @return
     */
    @Override
    public RelTenantRole queryOne(Long id) {
        return this.getOne(new LambdaQueryWrapper<RelTenantRole>().eq(RelTenantRole::getId,id));
    }

    /**
     * 查询租户角色关系列表
     * @param dto
     * @return
     */
    @Override
    public List<RelTenantRole> queryList(RelTenantRoleDto dto) {
        List<RelTenantRole> list = baseMapper.selectList(new LambdaQueryWrapper<RelTenantRole>()
                .eq(!Objects.isNull(dto.getId()),RelTenantRole::getId,dto.getId())
                .eq(StringUtils.isNotBlank(dto.getTenantBizId()),RelTenantRole::getTenantBizId,dto.getTenantBizId())
                .eq(StringUtils.isNotBlank(dto.getRoleBizId()),RelTenantRole::getRoleBizId,dto.getRoleBizId())
        );
        return list;
    }

    /**
     * 导入-选择角色分页查询
     * @param request
     * @return
     */
    @Override
    public IPage<ApiRelTenantRoleSelectPageResponse> selectProjectPage(Page<ApiRelTenantRoleSelectPageResponse> page,
                                                                       ApiRelTenantRoleSelectPageRequest request) {
        return baseMapper.selectProjectPage(page,request);
    }
}
