package com.yd.user.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiRelTenantRoleService;
import com.yd.user.feign.client.reltenantrole.ApiRelTenantRoleFeignClient;
import com.yd.user.feign.request.reltenantrole.ApiRelTenantRoleListAddRequest;
import com.yd.user.feign.request.reltenantrole.ApiRelTenantRoleListPageRequest;
import com.yd.user.feign.request.reltenantrole.ApiRelTenantRoleSelectPageRequest;
import com.yd.user.feign.response.reltenantrole.ApiRelTenantRoleListPageResponse;
import com.yd.user.feign.response.reltenantrole.ApiRelTenantRoleSelectPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 租户-角色关系信息（租户管理-角色配置）
 *
 * @author zxm
 * @since 2025-07-31
 */
@RestController
@RequestMapping("/relTenantRole")
@Validated
public class ApiRelTenantRoleController implements ApiRelTenantRoleFeignClient {

    @Autowired
    private ApiRelTenantRoleService apiRelTenantRoleService;

    /**
     * 租户和角色关系分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelTenantRoleListPageResponse>> page(ApiRelTenantRoleListPageRequest request) {
        return apiRelTenantRoleService.page(request);
    }

    /**
     * 添加租户和角色列表关系
     * @param request
     * @return
     */
    @Override
    public Result addRoleList(ApiRelTenantRoleListAddRequest request) {
        return apiRelTenantRoleService.addRoleList(request);
    }

    /**
     * 删除租户和角色关系
     * @param id 租户和角色关系表主键id
     * @return
     */
    @Override
    public Result del(Long id) {
        return apiRelTenantRoleService.del(id);
    }

    /**
     * 导入-选择角色分页查询（查询当前租户级（当前所属租户绑定的角色）或者系统级（全局角色在任何地方都适用导入绑定）的角色表数据）
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelTenantRoleSelectPageResponse>> selectRolePage(ApiRelTenantRoleSelectPageRequest request) {
        return apiRelTenantRoleService.selectRolePage(request);
    }
}
