package com.yd.user.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiUserSaleExpandService;
import com.yd.user.feign.client.usersaleexpand.ApiUserSaleExpandFeignClient;
import com.yd.user.feign.request.usersaleexpand.ApiUserSaleExpandAddRequest;
import com.yd.user.feign.request.usersaleexpand.ApiUserSaleExpandEditRequest;
import com.yd.user.feign.request.usersaleexpand.ApiUserSaleExpandPageRequest;
import com.yd.user.feign.response.usersaleexpand.ApiUserSaleExpandDetailResponse;
import com.yd.user.feign.response.usersaleexpand.ApiUserSaleExpandPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 系统用户-销售用户扩展信息
 *
 * @author zxm
 * @since 2025-12-19
 */
@RestController
@RequestMapping("/userSaleExpand")
@Validated
public class ApiUserSaleExpandController implements ApiUserSaleExpandFeignClient {

    @Autowired
    private ApiUserSaleExpandService apiUserSaleExpandService;

    /**
     * 销售员（转介人）分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiUserSaleExpandPageResponse>> page(ApiUserSaleExpandPageRequest request) {
        return apiUserSaleExpandService.page(request);
    }

    /**
     * 获取销售员（转介人）详情
     * @param userSaleBizId 销售员（转介人）唯一标识(业务ID)
     * @return
     */
    @Override
    public Result<ApiUserSaleExpandDetailResponse> detail(String userSaleBizId) {
        return apiUserSaleExpandService.detail(userSaleBizId);
    }

    /**
     * 添加销售员（转介人）
     * @param request
     * @return
     */
    @Override
    public Result add(ApiUserSaleExpandAddRequest request) {
        return apiUserSaleExpandService.add(request);
    }

    /**
     * 编辑销售员（转介人）
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiUserSaleExpandEditRequest request) {
        return apiUserSaleExpandService.edit(request);
    }

    /**
     * 删除销售员（转介人）（逻辑删除） TODO
     * @param userSaleBizId 销售员（转介人）唯一标识(业务ID)
     * @return
     */
    @Override
    public Result del(String userSaleBizId) {
        return apiUserSaleExpandService.del(userSaleBizId);
    }

    /**
     * 编辑销售员（转介人）状态
     * @param userSaleBizId 销售员（转介人）唯一标识(业务ID)
     * @param status 状态(0:禁用 1:启用)
     * @return
     */
    @Override
    public Result editStatus(String userSaleBizId, Integer status) {
        return apiUserSaleExpandService.editStatus(userSaleBizId,status);
    }
}
