package com.yd.user.feign.request.sysuser;

import com.yd.common.dto.PageDto;
import lombok.Data;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Data
public class ApiScopePageRequest extends PageDto {

    /**
     * 当前登录用户所属的租户id（当前页面右上角显示的租户）
     */
    @NotBlank(message = "当前登录用户所属的租户id（当前页面右上角显示的租户）不能为空")
    private String loginTenantBizId;

    /**
     * 作用域 1-系统级（全局） 2-租户级 3-项目级
     */
    @NotNull(message = "作用域不能为空")
    private Integer scope;

    /**
     * 搜索的名称（作用域对应的名称）
     */
    private String name;
}
