package com.yd.user.feign.response.clientuser;

import lombok.Data;
import java.time.LocalDateTime;
import java.util.List;

@Data
public class ApiClientUserDetailResponse {

    /**
     * 主键ID
     */
    private Long id;

    /**
     * 客户端用户表唯一业务ID
     */
    private String clientUserBizId;

    /**
     * 姓名
     */
    private String name;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 证件类型
     */
    private String idCardType;

    /**
     * 证件号码
     */
    private String idCardNumber;

    /**
     * 登录密码
     */
    private String password;

    /**
     * 邀请码
     */
    private String invitationCode;

    /**
     * 状态(0:停用 1:启用)
     */
    private Integer status;

    /**
     * 审批状态
     */
    private String approvalStatus;

    /**
     * 所属租户唯一业务ID（冗余）
     */
    private String tenantBizId;

    /**
     * 所属项目唯一业务ID（冗余）
     */
    private String projectBizId;

    /**
     * 用户唯一标识(sys_user系统用户表)
     */
    private String userBizId;

    /**
     * 通用备注
     */
    private String remark;

    /**
     * 删除标识: 0-正常, 1-删除
     */
    private Integer isDeleted;

    /**
     * 创建人ID
     */
    private String creatorId;

    /**
     * 更新人ID
     */
    private String updaterId;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 头像
     */
    private String avatar;

    /**
     * 证件文件url列表
     */
    private List<String> idCardFileUrlList;

    /**
     * 银行卡号
     */
    private String bankNumber;

    /**
     * 开户行
     */
    private String openBank;

    /**
     * 银行卡文件url列表
     */
    private List<String> bankFileUrlList;

    /**
     * 注册来源（PC、小程序等）默认小程序 - MINI_PROGRAM
     */
    private String registerSource;

    /**
     * 小程序的openId
     */
    private String openId;

}
