package com.yd.user.service.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 部门公共参数对象
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class SysDeptDto {

    /**
     * 部门表主键id
     */
    private Long id;

    /**
     * 部门唯一标识(业务ID)
     */
    private String deptBizId;

    /**
     * 部门唯一标识(业务ID)集合
     */
    private List<String> deptBizIdList;

    /**
     * 父部门ID
     */
    private String parentBizId;

    /**
     * 部门名称
     */
    private String deptName;

    /**
     * 查询是否排除当前部门唯一标识数据，默认false不排除，true的话projectBizId必传
     */
    @Builder.Default
    private Boolean isExcludeMy = false;
}
