package com.yd.user.service.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.user.feign.request.reluserrole.ApiCandidateProjectUserRolePageRequest;
import com.yd.user.feign.request.reluserrole.ApiCandidateTenantUserRolePageRequest;
import com.yd.user.feign.request.reluserrole.ApiSelectedProjectUserRolePageRequest;
import com.yd.user.feign.request.reluserrole.ApiSelectedTenantUserRolePageRequest;
import com.yd.user.feign.response.reluserrole.ApiCandidateProjectUserRolePageResponse;
import com.yd.user.feign.response.reluserrole.ApiCandidateTenantUserRolePageResponse;
import com.yd.user.feign.response.reluserrole.ApiSelectedProjectUserRolePageResponse;
import com.yd.user.feign.response.reluserrole.ApiSelectedTenantUserRolePageResponse;
import com.yd.user.service.dto.RelUserRoleDto;
import com.yd.user.service.model.RelUserRole;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * <p>
 * 用户-角色关系表（多对多关系） 服务类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
public interface IRelUserRoleService extends IService<RelUserRole> {

    void delRelTenantUserRole(String tenantBizId,String userBizId);

    void delRelTenantUserRole(String tenantBizId,String userBizId,List<String> roleBizIdList,Integer type);

    void delRelProjectUserRole(String projectBizId,String userBizId);

    void delRelProjectUserRole(String tenantBizId,String projectBizId,String userBizId,List<String> roleBizIdList,Integer type);

    IPage<ApiCandidateTenantUserRolePageResponse> candidateTenantUserRolePage(Page<ApiCandidateTenantUserRolePageResponse> page,
                                                                              ApiCandidateTenantUserRolePageRequest request);

    IPage<ApiSelectedTenantUserRolePageResponse> selectedTenantUserRolePage(Page<ApiSelectedTenantUserRolePageResponse> page,
                                                                           ApiSelectedTenantUserRolePageRequest request);

    IPage<ApiCandidateProjectUserRolePageResponse> candidateProjectUserRolePage(Page<ApiCandidateProjectUserRolePageResponse> page,
                                                                                ApiCandidateProjectUserRolePageRequest request);

    IPage<ApiSelectedProjectUserRolePageResponse> selectedProjectUserRolePage(Page<ApiSelectedProjectUserRolePageResponse> page,
                                                                              ApiSelectedProjectUserRolePageRequest request);

    List<RelUserRole> queryList(RelUserRoleDto dto);
}
