package com.yd.user.api.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiRelDeptUserService;
import com.yd.user.feign.client.reldeptuser.ApiRelDeptUserFeignClient;
import com.yd.user.feign.request.reldeptuser.ApiRelTenantDeptUserDelRequest;
import com.yd.user.feign.request.reldeptuser.ApiRelTenantDeptUserImportAddRequest;
import com.yd.user.feign.request.reldeptuser.ApiRelTenantDeptUserImportPageRequest;
import com.yd.user.feign.request.reldeptuser.ApiRelTenantDeptUserPageRequest;
import com.yd.user.feign.response.reldeptuser.ApiRelTenantDeptUserImportPageResponse;
import com.yd.user.feign.response.reldeptuser.ApiRelTenantDeptUserPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 部门-用户关系信息
 *
 * @author zxm
 * @since 2025-07-31
 */
@RestController
@RequestMapping("/relDeptUser")
@Validated
public class ApiRelDeptUserController implements ApiRelDeptUserFeignClient {

    @Autowired
    private ApiRelDeptUserService apiRelDeptUserService;

    /**
     * 租户管理-分配权限-部门配置-用户列表
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelTenantDeptUserPageResponse>> page(ApiRelTenantDeptUserPageRequest request) {
        return apiRelDeptUserService.page(request);
    }

    /**
     * 租户管理-分配权限-部门配置-用户列表删除
     * @param request
     * @return
     */
    @Override
    public Result del(ApiRelTenantDeptUserDelRequest request) {
        return apiRelDeptUserService.del(request);
    }

    /**
     * 租户管理-分配权限-部门配置-用户列表导入分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiRelTenantDeptUserImportPageResponse>> importPage(ApiRelTenantDeptUserImportPageRequest request) {
        return apiRelDeptUserService.importPage(request);
    }

    /**
     * 租户管理-分配权限-部门配置-用户列表导入添加
     * @param request
     * @return
     */
    @Override
    public Result importAdd(ApiRelTenantDeptUserImportAddRequest request) {
        return apiRelDeptUserService.importAdd(request);
    }
}
