package com.yd.user.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.result.Result;
import com.yd.user.api.service.ApiRelUserRoleService;
import com.yd.user.feign.request.reluserrole.*;
import com.yd.user.feign.response.reltenantuser.ApiRelTenantUserListPageResponse;
import com.yd.user.feign.response.reluserrole.ApiCandidateProjectUserRolePageResponse;
import com.yd.user.feign.response.reluserrole.ApiCandidateTenantUserRolePageResponse;
import com.yd.user.feign.response.reluserrole.ApiSelectedProjectUserRolePageResponse;
import com.yd.user.feign.response.reluserrole.ApiSelectedTenantUserRolePageResponse;
import com.yd.user.service.model.RelUserRole;
import com.yd.user.service.service.IRelUserRoleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class ApiRelUserRoleServiceImpl implements ApiRelUserRoleService {

    @Autowired
    private IRelUserRoleService iRelUserRoleService;

    /**
     * 租户管理-添加用户角色列表关系
     * @param request
     * @return
     */
    @Override
    public Result addTenantUserRoleList(ApiTenantUserRoleListAddRequest request) {

        //新增租户用户角色列表关系
        if (!CollectionUtils.isEmpty(request.getRoleBizIdList())) {
            List<RelUserRole> list = request.getRoleBizIdList().stream().map(bizId -> {
                RelUserRole relUserRole = new RelUserRole();
                relUserRole.setTenantBizId(request.getTenantBizId());
                relUserRole.setUserBizId(request.getUserBizId());
                relUserRole.setRoleBizId(bizId);
                return relUserRole;
            }).collect(Collectors.toList());

            iRelUserRoleService.saveOrUpdateBatch(list);
        }
        return Result.success();
    }

    /**
     * 租户管理-用户配置-分配角色-移除用户角色列表关系
     * @param request
     * @return
     */
    @Override
    public Result delTenantUserRoleList(ApiTenantUserRoleListDelRequest request) {
        iRelUserRoleService.delRelTenantUserRole(request.getTenantBizId(),
                request.getUserBizId(),request.getRoleBizIdList());
        return Result.success();
    }

    /**
     * 租户管理-用户配置-分配角色-查询待选的角色分页列表
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiCandidateTenantUserRolePageResponse>> candidateTenantUserRolePage(ApiCandidateTenantUserRolePageRequest request) {
        Page<ApiCandidateTenantUserRolePageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiCandidateTenantUserRolePageResponse> iPage = iRelUserRoleService.candidateTenantUserRolePage(page, request);
        return Result.success(iPage);
    }

    /**
     * 租户管理-用户配置-分配角色-查询选中的角色列表
     * @return
     */
    @Override
    public Result<IPage<ApiSelectedTenantUserRolePageResponse>> selectedTenantUserRolePage(ApiSelectedTenantUserRolePageRequest request) {
        Page<ApiSelectedTenantUserRolePageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiSelectedTenantUserRolePageResponse> iPage = iRelUserRoleService.selectedTenantUserRolePage(page, request);
        return Result.success(iPage);
    }

    /**
     * 项目管理-用户配置-分配角色-添加项目用户角色列表关系
     * @param request
     * @return
     */
    @Override
    public Result addProjectUserRoleList(ApiProjectUserRoleListAddRequest request) {
        //先删后新增关系
        //删除项目用户角色列表关系
//        iRelUserRoleService.delRelProjectUserRole(request.getProjectBizId(),request.getUserBizId());

        //新增项目用户角色列表关系
        if (!CollectionUtils.isEmpty(request.getRoleBizIdList())) {
            List<RelUserRole> list = request.getRoleBizIdList().stream().map(bizId -> {
                RelUserRole relUserRole = new RelUserRole();
                relUserRole.setProjectBizId(request.getProjectBizId());
                relUserRole.setUserBizId(request.getUserBizId());
                relUserRole.setRoleBizId(bizId);
                return relUserRole;
            }).collect(Collectors.toList());

            iRelUserRoleService.saveOrUpdateBatch(list);
        }
        return Result.success();
    }

    /**
     * 项目管理-用户配置-分配角色-移除用户角色列表关系
     * @param request
     * @return
     */
    @Override
    public Result delProjectUserRoleList(ApiProjectUserRoleListDelRequest request) {
        iRelUserRoleService.delRelProjectUserRole(request.getProjectBizId(),
                request.getUserBizId(),request.getRoleBizIdList());
        return Result.success();
    }

    /**
     * 项目管理-用户配置-分配角色-查询待选的角色分页列表
     * @return
     */
    @Override
    public Result<IPage<ApiCandidateProjectUserRolePageResponse>> candidateProjectUserRolePage(ApiCandidateProjectUserRolePageRequest request) {
        Page<ApiCandidateProjectUserRolePageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiCandidateProjectUserRolePageResponse> iPage = iRelUserRoleService.candidateProjectUserRolePage(page, request);
        return Result.success(iPage);
    }

    /**
     * 项目管理-用户配置-分配角色-查询选中的角色列表
     * @return
     */
    @Override
    public Result<IPage<ApiSelectedProjectUserRolePageResponse>> selectedProjectUserRolePage(ApiSelectedProjectUserRolePageRequest request) {
        Page<ApiSelectedProjectUserRolePageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiSelectedProjectUserRolePageResponse> iPage = iRelUserRoleService.selectedProjectUserRolePage(page, request);
        return Result.success(iPage);
    }

}
