package com.yd.user.feign.client.reltenantrole;

import com.yd.common.result.Result;
import com.yd.user.feign.fallback.reltenantrole.ApiRelTenantRoleFeignFallbackFactory;
import com.yd.user.feign.request.reltenantproject.ApiRelTenantProjectListAddRequest;
import com.yd.user.feign.request.reltenantproject.ApiRelTenantProjectSelectPageRequest;
import com.yd.user.feign.request.reltenantrole.ApiRelTenantRoleListAddRequest;
import com.yd.user.feign.request.reltenantrole.ApiRelTenantRoleListPageRequest;
import com.yd.user.feign.request.reltenantrole.ApiRelTenantRoleSelectPageRequest;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotNull;

/**
 * 用户服务：租户-角色关系信息Feign客户端
 */
@FeignClient(name = "yd-user-api", fallbackFactory = ApiRelTenantRoleFeignFallbackFactory.class)
public interface ApiRelTenantRoleFeignClient {


    /**
     * 租户和角色关系分页查询
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiRelTenantRoleListPageRequest request);

    /**
     * 添加租户和角色列表关系
     * @param request
     * @return
     */
    @PostMapping("/add/role/list")
    Result addRoleList(@Validated @RequestBody ApiRelTenantRoleListAddRequest request);

    /**
     * 删除租户和角色关系
     * @param id 租户和角色关系表主键id
     * @return
     */
    @DeleteMapping("/del")
    Result del(@NotNull(message = "租户和角色关系表主键id不能为空") @RequestParam(value = "id") Long id);

    /**
     * 导入-选择角色分页查询（查询当前租户级（当前所属租户绑定的角色）或者系统级（全局角色在任何地方都适用导入绑定）的角色表数据）
     * @param request
     * @return
     */
    @PostMapping("/select/role/page")
    Result selectRolePage(@Validated @RequestBody ApiRelTenantRoleSelectPageRequest request);
}
