package com.yd.user.service.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class RelRoleMenuDto {

    private Long id;

    /**
     * 租户ID（业务id）(冗余字段，目的当前关系是发生在哪个作用域下：租户级)
     */
    private String tenantBizId;

    /**
     * 项目ID（业务id）(冗余字段，目的当前关系是发生在哪个作用域下：项目级)
     */
    private String projectBizId;

    /**
     * 角色ID（业务id）
     */
    private String roleBizId;

    /**
     * 角色ID（业务id）集合
     */
    private List<String> roleBizIdList;

    /**
     * 菜单ID（业务id）
     */
    private String menuBizId;
}
