package com.yd.user.api.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.common.enums.CommonEnum;
import com.yd.common.enums.ResultCode;
import com.yd.common.exception.BusinessException;
import com.yd.common.result.Result;
import com.yd.common.utils.RandomStringGenerator;
import com.yd.user.api.service.ApiSysTenantService;
import com.yd.user.feign.request.systenant.ApiSysTenantAddRequest;
import com.yd.user.feign.request.systenant.ApiSysTenantEditRequest;
import com.yd.user.feign.request.systenant.ApiSysTenantPageRequest;
import com.yd.user.feign.response.systenant.ApiSysTenantDetailResponse;
import com.yd.user.feign.response.systenant.ApiSysTenantPageResponse;
import com.yd.user.service.dto.SysTenantDto;
import com.yd.user.service.model.SysTenant;
import com.yd.user.service.service.ISysTenantService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

@Service
public class ApiSysTenantServiceImpl implements ApiSysTenantService {

    @Autowired
    private ISysTenantService iSysTenantService;

    /**
     * 租户分页查询
     * @param request
     * @return
     */
    @Override
    public Result<IPage<ApiSysTenantPageResponse>> page(ApiSysTenantPageRequest request) {
        Page<ApiSysTenantPageResponse> page = new Page<>(request.getPageNo(), request.getPageSize());
        IPage<ApiSysTenantPageResponse> iPage = iSysTenantService.page(page, request);
        return Result.success(iPage);
    }

    /**
     * 获取租户详情
     * @param tenantUid 租户唯一标识(业务ID)
     * @return
     */
    @Override
    public Result<ApiSysTenantDetailResponse> detail(String tenantUid) {
        SysTenant sysTenant = iSysTenantService.queryOne(tenantUid);
        ApiSysTenantDetailResponse response = null;
        if (!Objects.isNull(sysTenant)) {
            response = new ApiSysTenantDetailResponse();
            BeanUtils.copyProperties(sysTenant,response);
        }
        return Result.success(response);
    }

    /**
     * 添加租户
     * @param request
     * @return
     */
    @Override
    public Result add(ApiSysTenantAddRequest request) {
        List<SysTenant> list = iSysTenantService.queryList(SysTenantDto.builder()
                .tenantName(request.getTenantName())
                .build());
        if (!CollectionUtils.isEmpty(list)) {
            //租户名称已存在
            throw new BusinessException(ResultCode.TENANT_NAME_EXISTS.getCode(),ResultCode.TENANT_NAME_EXISTS.getMessage());
        }
        //新增
        SysTenant sysTenant = new SysTenant();
        BeanUtils.copyProperties(request,sysTenant);
        sysTenant.setTenantUid(RandomStringGenerator.generateUid16(CommonEnum.UID_TYPE_TENANT.getCode()));
        iSysTenantService.save(sysTenant);
        return Result.success();
    }

    /**
     * 编辑租户
     * @param request
     * @return
     */
    @Override
    public Result edit(ApiSysTenantEditRequest request) {

        return Result.success();
    }
}
