package com.yd.user.feign.client.sysrole;

import com.yd.common.result.Result;
import com.yd.user.feign.fallback.sysrole.ApiSysRoleFeignFallbackFactory;
import com.yd.user.feign.request.sysrole.ApiSysRoleAddRequest;
import com.yd.user.feign.request.sysrole.ApiSysRoleEditRequest;
import com.yd.user.feign.request.sysrole.ApiSysRolePageRequest;
import com.yd.user.feign.response.sysrole.ApiSysRoleDetailResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * 用户服务-系统角色信息Feign客户端
 */
@FeignClient(name = "yd-user-api", fallbackFactory = ApiSysRoleFeignFallbackFactory.class)
public interface ApiSysRoleFeignClient {

    /**
     * 角色分页查询
     * @param request
     * @return
     */
    @PostMapping("/page")
    Result page(@RequestBody ApiSysRolePageRequest request);

    /**
     * 获取角色详情
     * @param roleUid 角色唯一标识(业务ID)
     * @return
     */
    @GetMapping("/detail")
    Result<ApiSysRoleDetailResponse> detail(@RequestParam(value = "roleUid") String roleUid);

    /**
     * 添加角色
     * @param request
     * @return
     */
    @PostMapping("/add")
    Result add(@RequestBody ApiSysRoleAddRequest request);

    /**
     * 编辑角色
     * @param request
     * @return
     */
    @PostMapping("/edit")
    Result edit(@RequestBody ApiSysRoleEditRequest request);


    /**
     * 删除角色（逻辑删除）
     * @param roleUid 角色唯一标识(业务ID)
     * @return
     */
    @DeleteMapping("/del")
    Result del(@RequestParam(value = "roleUid") String roleUid);

    /**
     * 编辑角色状态
     * @param roleUid 角色唯一标识(业务ID)
     * @param status 状态(0:禁用 1:启用)
     * @return
     */
    @DeleteMapping("/edit/status")
    Result editStatus(@RequestParam(value = "roleUid") String roleUid,
                      @RequestParam(value = "status") Integer status);
}
