package com.yd.user.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yd.user.feign.request.systenant.ApiSysTenantPageRequest;
import com.yd.user.feign.response.systenant.ApiSysTenantPageResponse;
import com.yd.user.service.dto.SysTenantDto;
import com.yd.user.service.model.SysTenant;
import com.yd.user.service.dao.SysTenantMapper;
import com.yd.user.service.service.ISysTenantService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 租户信息表 服务实现类
 * </p>
 *
 * @author zxm
 * @since 2025-07-31
 */
@Service
public class SysTenantServiceImpl extends ServiceImpl<SysTenantMapper, SysTenant> implements ISysTenantService {

    /**
     * 租户分页查询
     * @param request
     * @return
     */
    @Override
    public IPage<ApiSysTenantPageResponse> page(Page<ApiSysTenantPageResponse> page, ApiSysTenantPageRequest request) {
        return baseMapper.page(page,request);
    }

    /**
     * 根据租户唯一标识查询单个对象
     * @param tenantUid
     * @return
     */
    @Override
    public SysTenant queryOne(String tenantUid) {
        return this.getOne(new LambdaQueryWrapper<SysTenant>().eq(SysTenant::getTenantUid,tenantUid));
    }

    /**
     * 查询租户列表信息
     * @param dto
     * @return
     */
    @Override
    public List<SysTenant> queryList(SysTenantDto dto) {
        List<SysTenant> list = baseMapper.selectList(new LambdaQueryWrapper<SysTenant>()
                .eq(!Objects.isNull(dto.getId()),SysTenant::getId,dto.getId())
                .eq(StringUtils.isNotBlank(dto.getTenantUid()),SysTenant::getTenantUid,dto.getTenantUid())
                .eq(StringUtils.isNotBlank(dto.getTenantName()),SysTenant::getTenantName,dto.getTenantName())
                .eq(!Objects.isNull(dto.getStatus()),SysTenant::getStatus,dto.getStatus())
                .ne(dto.getIsExcludeMy(),SysTenant::getTenantUid,dto.getTenantUid())
        );
        return list;
    }

}
