package com.yd.user.feign.response.sysdict;

import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 根据字典类型获取字典数据项列表出参
 */
@Data
public class GetDictItemListByDictTypeResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 字典项表主键id
     */
    private Long id;

    /**
     * 字典类型
     */
    private String dictType;

    /**
     * 字典数据id（业务id）
     */
    private String dictItemBizId;

    /**
     * 字典ID（字典类型表id）（业务id）
     */
    private String dictBizId;

    /**
     * 字典项标签（名称）
     */
    private String itemLabel;

    /**
     * 字典项值（值）
     */
    private String itemValue;

    /**
     * 是否默认(0:否 1:是)
     */
    private Integer isDefault;

    /**
     * 排序
     */
    private Integer orderNum;

    /**
     * 状态(0:停用 1:启用)
     */
    private Integer status;

    /**
     * 根据字典类型和字典值获取名称
     * @param list
     * @param dictType
     * @param itemValue
     * @return
     */
    public static String getItemLabel(List<GetDictItemListByDictTypeResponse> list,
                                      String dictType,String itemValue) {
        String itemLabel = "";
        if (!CollectionUtils.isEmpty(list)) {
            List<GetDictItemListByDictTypeResponse> singeList = list.stream()
                    .filter(item -> item.getDictType().equals(dictType) && item.getItemValue().equals(itemValue))
                    .collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(singeList)) {
                GetDictItemListByDictTypeResponse typeResponse = singeList.get(0);
                itemLabel = typeResponse.getItemLabel();
            }
        }
        return itemLabel;
    }

    /**
     * 根据字典类型和字典名称获取字典值
     * @param list
     * @param dictType
     * @param itemLabel
     * @return
     */
    public static String getItemValue(List<GetDictItemListByDictTypeResponse> list,
                                      String dictType,String itemLabel) {
        String itemValue = "";
        if (!CollectionUtils.isEmpty(list)) {
            List<GetDictItemListByDictTypeResponse> singeList = list.stream()
                    .filter(item -> item.getDictType().equals(dictType) && item.getItemLabel().equals(itemLabel))
                    .collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(singeList)) {
                GetDictItemListByDictTypeResponse typeResponse = singeList.get(0);
                itemValue = typeResponse.getItemValue();
            }
        }
        return itemValue;
    }
}
