package com.yd.user.service.dto;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import java.util.List;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ClientUserDto {

    /**
     * 客户端用户表唯一业务ID
     */
    private String clientUserBizId;

    /**
     * 所属租户唯一业务ID（冗余）
     */
    private String tenantBizId;

    /**
     * 所属项目唯一业务ID（冗余）
     */
    private String projectBizId;

    /**
     * 用户唯一标识(sys_user系统用户表)列表
     */
    private List<String> userBizIdList;
}
