import { createI18n } from 'vue-i18n'
import zhCN from './zh-CN'
// import zhTW from './zh-TW'
import enUS from './en-US'
// import jaJP from './ja-JP'
// import koKR from './ko-KR'

// 创建 i18n 实例
const i18n = createI18n({
  legacy: false, // 使用 Composition API 模式
  locale: localStorage.getItem('lang') || 'zh-CN', // 默认语言
  messages: {
    'zh-CN': zhCN,
    // 'zh-TW': zhTW,
    'en-US': enUS
    // 'ja-JP': jaJP,
    // 'ko-KR': koKR
  }
})

export default i18n
