import request from '@/utils/request'

// 获取保单来佣列表
export function getPolicyCommissionList(data) {
  return request({
    url: '/csf/api/commission/list/page/vo',
    method: 'post',
    data: data
  })
}

// 更新保单来佣信息
export function updatePolicyCommission(data) {
  return request({
    url: '/csf/api/commission/update',
    method: 'post',
    data: data
  })
}

// 生成可出账记录
export function generateCommissionRecord(data) {
  return request({
    url: '/csf/api/commission/generate/fortune',
    method: 'post',
    data: data
  })
}

// 更新保单发佣信息
export function updatePolicyFortune(data) {
  return request({
    url: '/csf/api/fortune/update',
    method: 'post',
    data: data
  })
}

// 获取保单发佣列表

export function getPolicyFortuneList(data) {
  return request({
    url: '/csf/api/fortune/list/page/vo',
    method: 'post',
    data: data
  })
}

// 下载选中的发佣数据

export function downloadPolicyFortune(data) {
  return request({
    url: '/csf/api/fortune/download',
    method: 'post',
    data: data
  })
}

// 生成出账清单
// /csf/api/fortune/download/account
export function downloadPolicyFortuneAccount(data) {
  return request({
    url: '/csf/api/fortune/download/account',
    method: 'post',
    data: data
  })
}

// 按照人的维度，查询出账列表
export function getReferrerFortuneList(data) {
  return request({
    url: '/csf/api/fortune/list/page/fortuneAccount',
    method: 'post',
    data: data
  })
}
