/**
 * 1.普通模块得数据格式，无子级：
 * {
   一些页面用到得属性，比如个人资料模块得数据格式
  data:[] data主要是这个模块对应得表单dom数据
 }
 2. 有子级得模块得数据格式：
 {
  一些页面用到得属性，比如家庭状况模块得数据格式
  data:[  data主要父级模块对应得表单
    {
      比如家庭状况中有父亲，母亲，配偶，这个对象就代表这些人
      children:[]，代表得是这些人对应得表单dom
    }

  ]
 }

 以上两种格式说明了fnaForm页面得dom数据格式，如果有子级得dom请参照2格式添加，否则可能有未知错误
 */
const fnaForm = [
  {
    fatherTitle: '个人资料',
    keyType: 'Object', //用于表单收集值时，判断是数组还是对象
    key: 'personalData',
    child: 'no', //没有子级dom，直接展示
    fatherRequired: true, //父级必填,代表个人资料这个模块有必填项
    data: [
      {
        label: '陪同顾问姓名',
        key: 'accountName',
        domType: 'SearchSelect',
        required: true,
        maxLength: 30,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        labelPosition: 'right', //标签的位置
        lg: 8 //栅格布局份数
      },

      {
        label: '理财顾问注册编号',
        key: 'registrationNumber',
        domType: 'Input',
        inputType: 'text',
        required: true,
        maxLength: 30,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelWidth: '130px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8, //栅格布局份数,
        labelPosition: 'right', //标签的位置
        labelWidth: '140px'
      },
      {
        label: '理财顾问内部编码',
        key: 'number',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 30,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelWidth: '130px', //标签宽度
        labelPosition: 'right', //标签的位置
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '客户姓名',
        key: 'customerName',
        domType: 'Input',
        inputType: 'text',
        required: true,
        maxLength: 30,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelWidth: '120px', //标签宽度
        labelPosition: 'right', //标签的位置
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '税务国家',
        key: 'taxCountry',
        domType: 'Input',
        inputType: 'text',
        required: true,
        maxLength: 30,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        labelPosition: 'right', //标签的位置
        lg: 8 //栅格布局份数
      },
      {
        label: '就业情况',
        key: 'employment',
        domType: 'Select',
        required: true,
        maxLength: 30,
        disabled: false,
        placeholder: '请输入',
        show: true,
        dictType: 'csf_employment',
        labelWidth: '120px', //标签宽度
        labelPosition: 'right', //标签的位置
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '是否退休',
        key: 'isRetired',
        domType: 'Select',
        required: true,
        maxLength: 30,
        disabled: false,
        placeholder: '请输入',
        show: true,
        dictType: 'sys_no_yes',
        labelWidth: '120px', //标签宽度
        labelPosition: 'right', //标签的位置
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '退休年龄',
        key: 'retiredAge',
        domType: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 30,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelWidth: '120px', //标签宽度
        labelPosition: 'right', //标签的位置
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },

      {
        label: '其他就业情况',
        key: 'otherEmployment',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: false,
        labelWidth: '120px', //标签宽度
        labelPosition: 'right', //标签的位置
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      }
    ]
  },
  //家庭状况
  {
    fatherTitle: '家庭状况',
    keyType: 'Array', //用于表单收集值时，判断是数组还是对象
    key: 'familyMembers',
    child: 'yes', //有子级dom,需要循环展示
    addFamilyChildren: true, //是否可以新增子级dom
    fatherRequired: false, //父级必填,代表个人资料这个模块有必填项
    data: [
      {
        type: '1',
        childTitle: '父亲',
        id: Date.now() + Math.floor(Math.random() * 1000), //唯一标识
        span: 24, //栅格布局份数
        children: [
          {
            label: '年龄',
            key: 'age',
            domType: 'Input',
            inputType: 'number',
            required: false,
            maxLength: 30,
            disabled: false,
            placeholder: '请输入',
            show: true,
            labelWidth: '120px', //标签宽度
            sm: 10, //栅格布局份数
            lg: 8 //栅格布局份数
          },
          {
            label: '是否需要供养',
            key: 'needProvide',
            domType: 'Select',
            required: false,
            maxLength: 30,
            disabled: false,
            placeholder: '请输入',
            show: true,
            dictType: 'sys_no_yes',
            labelWidth: '120px', //标签宽度
            sm: 10, //栅格布局份数
            lg: 8 //栅格布局份数
          }
        ]
      },
      {
        type: '2',
        childTitle: '母亲',
        id: Date.now() + Math.floor(Math.random() * 1000), //唯一标识
        span: 24, //栅格布局份数
        children: [
          {
            label: '年龄',
            key: 'age',
            domType: 'Input',
            inputType: 'number',
            required: false,
            maxLength: 30,
            disabled: false,
            placeholder: '请输入',
            show: true,
            labelWidth: '120px', //标签宽度
            sm: 10, //栅格布局份数
            lg: 8 //栅格布局份数
          },
          {
            label: '是否需要供养',
            key: 'needProvide',
            domType: 'Select',
            required: false,
            maxLength: 30,
            disabled: false,
            placeholder: '请输入',
            show: true,
            dictType: 'sys_no_yes',
            labelWidth: '120px', //标签宽度
            sm: 10, //栅格布局份数
            lg: 8 //栅格布局份数
          }
        ]
      },
      {
        type: '3',
        childTitle: '配偶',
        id: Date.now() + Math.floor(Math.random() * 1000), //唯一标识
        span: 24, //栅格布局份数
        children: [
          {
            label: '年龄',
            key: 'age',
            domType: 'Input',
            inputType: 'number',
            required: false,
            maxLength: 30,
            disabled: false,
            placeholder: '请输入',
            show: true,
            labelWidth: '120px', //标签宽度
            sm: 10, //栅格布局份数
            lg: 8 //栅格布局份数
          },
          {
            label: '是否需要供养',
            key: 'needProvide',
            domType: 'Select',
            required: false,
            maxLength: 30,
            disabled: false,
            placeholder: '请输入',
            show: true,
            dictType: 'sys_no_yes',
            labelWidth: '120px', //标签宽度
            sm: 10, //栅格布局份数
            lg: 8 //栅格布局份数
          }
        ]
      }
    ]
  },
  //财务需要分析
  {
    fatherTitle: '财务需要分析',
    keyType: 'Array', //用于表单收集值时，判断是数组还是对象
    key: 'existingSecurityOwner',
    dataLength: 5, //设置dataLength,用于控制子级dom的个数，子级保存一个样例数据，便于加子级数据
    child: 'yes', //有子级dom,需要循环展示
    fatherRequired: false, //父级必填,代表个人资料这个模块有必填项
    data: [
      {
        id: Date.now() + Math.floor(Math.random() * 1000), //唯一标识
        span: 24, //栅格布局份数
        childTitle: '保单持有人个人已有保障',
        children: [
          {
            label: '保险公司',
            key: 'insurer',
            domType: 'Input',
            inputType: 'text',
            required: false,
            maxLength: 300,
            disabled: false,
            placeholder: '请输入',
            show: true,
            labelWidth: '120px', //标签宽度
            sm: 12, //栅格布局份数
            lg: 8 //栅格布局份数
          },
          {
            label: '保障类型',
            key: 'insuranceType',
            domType: 'Input',
            inputType: 'text',
            required: false,
            maxLength: 300,
            disabled: false,
            placeholder: '请输入',
            show: true,
            labelWidth: '120px', //标签宽度
            sm: 12, //栅格布局份数
            lg: 8 //栅格布局份数
          },
          {
            label: '保额',
            key: 'sumInsured',
            domType: 'Input',
            inputType: 'text',
            required: false,
            maxLength: 300,
            disabled: false,
            placeholder: '请输入',
            show: true,
            labelWidth: '120px', //标签宽度
            sm: 12, //栅格布局份数
            lg: 8 //栅格布局份数
          },
          {
            label: '币种',
            key: 'currency',
            domType: 'Select',
            inputType: 'text',
            required: false,
            maxLength: 300,
            disabled: false,
            placeholder: '请输入',
            show: true,
            dictType: 'bx_currency_type',
            labelWidth: '120px', //标签宽度
            sm: 12, //栅格布局份数
            lg: 8 //栅格布局份数
          },
          {
            label: '保单签发日期',
            key: 'policyIssueDate',
            domType: 'DatePicker',
            required: false,
            maxLength: 300,
            disabled: false,
            placeholder: '请输入',
            show: true,
            labelWidth: '120px', //标签宽度
            sm: 12, //栅格布局份数
            lg: 8 //栅格布局份数
          }
        ]
      }
    ]
  },
  //受保人个人已有保障
  {
    keyType: 'Array', //用于表单收集值时，判断是数组还是对象
    key: 'existingSecurityInsured',
    dataLength: 5, //设置dataLength,用于控制子级dom的个数，子级保存一个样例数据，便于加子级数据
    child: 'yes', //有子级dom,需要循环展示
    fatherRequired: false, //父级必填,代表个人资料这个模块有必填项
    data: [
      {
        childTitle: '受保人个人已有保障',
        id: Date.now() + Math.floor(Math.random() * 1000), //唯一标识
        span: 24, //栅格布局份数
        children: [
          {
            label: '保险公司',
            key: 'insurer',
            domType: 'Input',
            inputType: 'text',
            required: false,
            maxLength: 300,
            disabled: false,
            placeholder: '请输入',
            show: true,
            labelWidth: '120px', //标签宽度
            sm: 12, //栅格布局份数
            lg: 8 //栅格布局份数
          },
          {
            label: '保障类型',
            key: 'insuranceType',
            domType: 'Input',
            inputType: 'text',
            required: false,
            maxLength: 300,
            disabled: false,
            placeholder: '请输入',
            show: true,
            labelWidth: '120px', //标签宽度
            sm: 12, //栅格布局份数
            lg: 8 //栅格布局份数
          },
          {
            label: '保额',
            key: 'sumInsured',
            domType: 'Input',
            inputType: 'text',
            required: false,
            maxLength: 300,
            disabled: false,
            placeholder: '请输入',
            show: true,
            labelWidth: '120px', //标签宽度
            sm: 12, //栅格布局份数
            lg: 8 //栅格布局份数
          },
          {
            label: '币种',
            key: 'currency',
            domType: 'Select',
            inputType: 'text',
            required: false,
            maxLength: 300,
            disabled: false,
            placeholder: '请输入',
            show: true,
            dictType: 'bx_currency_type',
            labelWidth: '120px', //标签宽度
            sm: 12, //栅格布局份数
            lg: 8 //栅格布局份数
          },
          {
            label: '保单签发日期',
            key: 'policyIssueDate',
            domType: 'DatePicker',
            required: false,
            maxLength: 300,
            disabled: false,
            placeholder: '请输入',
            show: true,
            labelWidth: '120px', //标签宽度
            sm: 12, //栅格布局份数
            lg: 8 //栅格布局份数
          }
        ]
      }
    ]
  },
  //保单持有人资产
  {
    keyType: 'Array', //用于表单收集值时，判断是数组还是对象
    key: 'primaryResidence',
    dataLength: 1, //设置dataLength,用于控制子级dom的个数，子级保存一个样例数据，便于加子级数据
    child: 'yes', //有子级dom,需要循环展示
    subTitle: '保单持有人资产',
    fatherRequired: false, //父级必填,代表个人资料这个模块有必填项
    data: [
      {
        childTitle: '自住用途之房地产',
        id: Date.now() + Math.floor(Math.random() * 1000), //唯一标识
        span: 24, //栅格布局份数
        children: [
          {
            label: '自住用途之房地产地址',
            key: 'address',
            domType: 'Input',
            inputType: 'text',
            required: false,
            maxLength: 300,
            disabled: false,
            placeholder: '请输入',
            show: true,
            labelWidth: '180px', //标签宽度
            sm: 12, //栅格布局份数
            lg: 8 //栅格布局份数
          },
          {
            label: '币种',
            key: 'currency',
            domType: 'Select',
            inputType: 'text',
            required: false,
            maxLength: 300,
            disabled: false,
            placeholder: '请输入',
            show: true,
            dictType: 'bx_currency_type',
            labelWidth: '120px', //标签宽度
            sm: 12, //栅格布局份数
            lg: 8 //栅格布局份数
          },
          {
            label: '自住用途之房地产市值(HKD)',
            key: 'marketValue',
            domType: 'Input',
            inputType: 'text',
            required: false,
            maxLength: 300,
            disabled: false,
            placeholder: '请输入',
            show: true,
            labelWidth: '220px', //标签宽度
            sm: 12, //栅格布局份数
            lg: 8 //栅格布局份数
          }
        ]
      }
    ]
  },
  {
    keyType: 'Array', //用于表单收集值时，判断是数组还是对象
    key: 'investment',
    dataLength: 2, //设置dataLength,用于控制子级dom的个数，子级保存一个样例数据，便于加子级数据
    child: 'yes', //有子级dom,需要循环展示
    fatherRequired: false, //父级必填,代表个人资料这个模块有必填项
    data: [
      {
        childTitle: '投资房地产',
        id: Date.now() + Math.floor(Math.random() * 1000), //唯一标识
        span: 24, //栅格布局份数
        children: [
          {
            label: '地址',
            key: 'address',
            domType: 'Input',
            inputType: 'text',
            required: false,
            maxLength: 300,
            disabled: false,
            placeholder: '请输入',
            show: true,
            labelWidth: '120px', //标签宽度
            sm: 12, //栅格布局份数
            lg: 8 //栅格布局份数
          },
          {
            label: '币种',
            key: 'currency',
            domType: 'Select',
            inputType: 'text',
            required: false,
            maxLength: 300,
            disabled: false,
            placeholder: '请输入',
            show: true,
            dictType: 'bx_currency_type',
            labelWidth: '120px', //标签宽度
            sm: 12, //栅格布局份数
            lg: 8 //栅格布局份数
          },
          {
            label: '市值(HKD)',
            key: 'marketValue',
            domType: 'Input',
            inputType: 'text',
            required: false,
            maxLength: 300,
            disabled: false,
            placeholder: '请输入',
            show: true,
            labelWidth: '120px', //标签宽度
            sm: 12, //栅格布局份数
            lg: 8 //栅格布局份数
          }
        ]
      }
    ]
  },
  //公司业务资料
  {
    keyType: 'Object', //用于表单收集值时，判断是数组还是对象
    key: 'companyBusinessData',
    child: 'no', //有子级dom,需要循环展示
    fatherRequired: false, //父级必填,代表个人资料这个模块有必填项
    subTitle: '公司业务资料 (适用于公司老板跟股东)',
    data: [
      {
        label: '公司過去兩年平均純利 (HKD)',
        key: 'averageNetProfit',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelWidth: '220px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '公司現時大約的總資產 (HKD)',
        key: 'estimatedTotalAssets',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelWidth: '200px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '币种',
        key: 'currency',
        domType: 'Select',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        dictType: 'bx_currency_type',
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '资产所佔百分比 (%)',
        key: 'assetPercentage',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelWidth: '170px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      }
    ]
  },
  //支出
  {
    key: 'incomeExpense',
    keyType: 'Object', //用于表单收集值时，判断是数组还是对象
    child: 'no',
    fatherRequired: false, //父级必填,代表个人资料这个模块有必填项
    data: [
      {
        label:
          '在过去24个月里,你从所有所得的收入来源所得的平均每月收入为(包括薪金、花红、佣金、其他薪酬红利、银行存款利息、债券利息及股息等。',
        key: 'monthlyIncome',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入金额(HKD)',
        show: true,
        inputWidth: '300px',
        labelWidth: '800px', //标签宽度
        sm: 24, //栅格布局份数
        lg: 24, //栅格布局份数
        labelPosition: 'top' //标签的位置
      },
      {
        label: '过去24个月每月里,你每月的平均开支为',
        key: 'monthlyExpense',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入金额(HKD)',
        show: true,
        inputWidth: '300px', //输入框宽度
        labelWidth: '260px', //标签宽度
        sm: 24, //栅格布局份数
        lg: 12 //栅格布局份数
      }
    ]
  },
  {
    key: 'liquidAssets',
    keyType: 'Object', //用于表单收集值时，判断是数组还是对象
    child: 'no',
    fatherRequired: false, //父级必填,代表个人资料这个模块有必填项
    data: [
      {
        label: '您现时的累积流动资产约有多少?',
        key: 'liquidAssets',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入金额(HKD)',
        show: true,
        inputWidth: '300px', //输入框宽度
        labelWidth: '220px', //标签宽度
        sm: 24, //栅格布局份数
        lg: 12, //栅格布局份数
        labelPosition: 'right' //标签的位置
      },
      {
        label: '流动资产种类',
        key: 'liquidAssetType',
        domType: 'Checkbox',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入金额(HKD)',
        show: true,
        labelWidth: '100px', //标签宽度
        sm: 20, //栅格布局份数
        lg: 20, //栅格布局份数
        labelPosition: 'right', //标签的位置
        dictType: 'csf_liquid_asset_type'
      },
      {
        label: '',
        key: 'otherLiquidAsset',
        domType: 'Input',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入说明',
        show: true,
        labelWidth: '0px', //标签宽度
        sm: 4, //栅格布局份数
        lg: 4, //栅格布局份数
        labelPosition: 'right' //标签的位置
      }
    ]
  },

  {
    fatherTitle: '',
    keyType: 'Object', //用于表单收集值时，判断是数组还是对象
    child: 'no',
    fatherRequired: false, //父级必填,代表个人资料这个模块有必填项
    key: 'other',
    data: [
      {
        label: '首期及续保保费的财富来源',
        key: 'premiumFundingSource',
        domType: 'Checkbox',
        required: false,
        maxLength: 30,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelWidth: '180px', //标签宽度
        sm: 24, //栅格布局份数
        lg: 24, //栅格布局份数
        dictType: 'csf_premium_funding_source'
      }
    ]
  }
]
export default fnaForm
