import request from '@/utils/request'

// 分页获取新单跟进列表
export function getPolicyFollowList(data) {
  return request({
    url: '/csf/api/policy_follow/list/page/vo',
    method: 'post',
    data: data
  })
}

// 获取预计来佣列表
// /csf/api/commission/list/page/commission_expected
export function getExpectedCommissionList(data) {
  return request({
    url: '/csf/api/policy/list/page/commission_expected',
    method: 'post',
    data: data
  })
}

// 更新至保单库
export function updateToPolicyLib(data) {
  return request({
    url: '/csf/api/policy_follow/addToPolicy',
    method: 'post',
    data: data
  })
}
// 更新新单跟进
export function updatePolicyfollow(data) {
  return request({
    url: '/csf/api/policy_follow/update',
    method: 'post',
    data: data
  })
}
// 获取新单跟进详情
export function getPolicyfollow(policyBizId) {
  return request({
    url: `/csf/api/policy_follow/get/vo?policyBizId=${policyBizId}`,
    method: 'get'
  })
}
// 获取新单跟进详情
export function getPolicyInfo(policyBizId) {
  return request({
    url: `/csf/api/policy_follow/detail/${policyBizId}`,
    method: 'get'
  })
}
// 获取新单跟进状态
export function getPolicyStatus(policyBizId) {
  return request({
    url: `/csf/api/policy_follow/status/list?policyBizId=${policyBizId}`,
    method: 'get'
  })
}
// 获取预计来佣生成状态
export function expectedFortuneIsGenerate(policyNo) {
  return request({
    url: `/csf/api/expectedFortune/isGenerate?policyNo=${policyNo}`,
    method: 'get'
  })
}
// 生成签约单
export function policyFollowReport(policyBizId) {
  return request({
    url: `/csf/api/policy_follow/report/download?policyBizId=${policyBizId}`,
    method: 'get',
    responseType: 'blob' // 关键设置
  })
}
// 生成预计发佣
export function expectedFortuneGenerate(data) {
  return request({
    url: '/csf/api/expectedFortune/generate',
    method: 'post',
    data: data
  })
}
//发佣日志信息
export function getExpectedFortuneLog(data) {
  return request({
    url: '/csf/api/expectedFortuneLog/page',
    method: 'post',
    data: data
  })
}
// 新单跟进附件列表
export function getAttachmentList(data) {
  return request({
    url: '/csf/api/policy_follow/attachment/list/page',
    method: 'post',
    data: data
  })
}

// 删除单个新单跟进附件
export function delAttachmentFile(fileId) {
  return request({
    url: '/csf/api/policy_follow/attachment/delete?fileId=' + fileId,
    method: 'delete'
  })
}
// 上传新单跟进附件
export function uploadPolicyfollow(data) {
  return request({
    url: '/csf/api/policy_follow/attachment/upload',
    method: 'post',
    data: data
  })
}
// 新单跟进详情中的产品计划提交
export function updatePolicyProduct(data) {
  return request({
    url: '/csf/api/policy/update',
    method: 'post',
    data: data
  })
}
// 删除附加险
export function delPolicyAdditional(id) {
  return request({
    url: '/csf/api/policy_additional/delete?id=' + id,
    method: 'delete'
  })
}
// 新单跟进详情中的投保人提交
export function updatePolicyholder(data) {
  return request({
    url: '/csf/api/policy/update_policyholder',
    method: 'post',
    data: data
  })
}
// 新单跟进详情中的受保人提交
export function updatePolicyInsurant(data) {
  return request({
    url: '/csf/api/policy/update_policy_insurant',
    method: 'post',
    data: data
  })
}
// 新单跟进详情中的第二持有人提交
export function updatePolicySecondHolder(data) {
  return request({
    url: '/csf/api/policy/update_policy_second_holder',
    method: 'post',
    data: data
  })
}
// 新单跟进详情中的受益人提交
export function updatePolicyBeneficiary(data) {
  return request({
    url: '/csf/api/policy_beneficiary/update/list',
    method: 'post',
    data: data
  })
}
// 删除单个受益人
export function delPolicyBeneficiary(policyBeneficiaryBizId) {
  return request({
    url: '/csf/api/policy_beneficiary/delete?policyBeneficiaryBizId=' + policyBeneficiaryBizId,
    method: 'delete'
  })
}
// 新单跟进的预计来佣列表
export function getCommissionList(data) {
  return request({
    url: '/csf/api/CommissionExpected/list/page',
    method: 'post',
    data: data
  })
}
// 新单跟进的预计发佣列表
export function getExpectedFortuneList(data) {
  return request({
    url: '/csf/api/expectedFortune/page',
    method: 'post',
    data: data
  })
}
// 新单跟进的预计来佣单个提交
export function editSigalCommission(data) {
  return request({
    url: '/csf/api/CommissionExpected/update',
    method: 'post',
    data: data
  })
}
// 新单跟进的预计来佣批量提交
export function editMultipleCommission(data) {
  return request({
    url: '/csf/api/CommissionExpected/add',
    method: 'post',
    data: data
  })
}
// 删除单个来佣
export function delCommissionExpected(commissionExpectedBizId) {
  return request({
    url: '/csf/api/CommissionExpected/delete?commissionExpectedBizId=' + commissionExpectedBizId,
    method: 'delete'
  })
}
// 编辑新单跟进状态
export function changePolicyStatus(data) {
  return request({
    url: '/csf/api/policy_follow/change_status',
    method: 'post',
    data: data
  })
}

