import request from '@/utils/request'

// 查询fna列表
export function getFnaList(data) {
  return request({
    url: '/csf/api/Fna/list/page',
    method: 'post',
    data: data
  })
}
/*
流程接口开始
 */
// 删除流程
export function deleteFna(data) {
  return request({
    url: '/csf/api/Fna/delete',
    method: 'post',
    data: data
  })
}
// 新建流程
export function addFna(data) {
  return request({
    url: '/csf/api/Fna/add',
    method: 'post',
    data: data
  })
}
// 查询流程详情
export function getProcessDetail(fnaBizId) {
  return request({
    url: `/csf/api/Fna/get/vo?fnaBizId=${fnaBizId}`,
    method: 'get'
  })
}
// 更新流程
export function updateProcess(data) {
  return request({
    url: '/csf/api/Fna/update',
    method: 'post',
    data: data
  })
}
/*
流程接口结束
 */

/*
客户模块接口开始
 */
// 新增客户信息
export function addCustomer(data) {
  return request({
    url: '/csf/api/Customer/add',
    method: 'post',
    data: data
  })
}
// 获取客户详情
export function getCustomerDetail(customerBizId) {
  return request({
    url: `/csf/api/Customer/get/vo?customerBizId=${customerBizId}`,
    method: 'get'
  })
}
// 修改客户信息
export function editCustomer(data) {
  return request({
    url: '/csf/api/Customer/update',
    method: 'post',
    data: data
  })
}
// 获取客户列表信息
export function getCustomerList(data) {
  return request({
    url: '/csf/api/Customer/list/page/vo',
    method: 'post',
    data: data
  })
}
/*
客户模块接口结束
 */
/*
fanForm模块接口开始
 */
// 新增fanForm信息
export function addfanForm(data) {
  return request({
    url: '/csf/api/FnaForm/add',
    method: 'post',
    data: data
  })
}
// 获取fanForm信息详情
export function getfanFormDetail(fnaFormBizId) {
  return request({
    url: `/csf/api/FnaForm/get/vo?fnaFormBizId=${fnaFormBizId}`,
    method: 'get'
  })
}
// 修改客户信息
export function editFanForm(data) {
  return request({
    url: '/csf/api/FnaForm/update',
    method: 'post',
    data: data
  })
}
/*
fanForm模块接口结束
 */
// 修改角色
export function roleUpdate(data) {
  return request({
    url: '/user/api/sysRole/edit',
    method: 'put',
    data: data
  })
}

// 删除角色
export function delRole(roleId) {
  return request({
    url: '/system/role/' + roleId,
    method: 'delete'
  })
}

// 编辑角色状态
export function roleStatusChange(roleBizId, status) {
  return request({
    url: `/user/api/sysRole/edit/status?roleBizId=${roleBizId}&status=${status}`,
    method: 'patch'
  })
}

// 查询角色详情
export function getRoleDetail(roleBizId) {
  return request({
    url: `/user/api/sysRole/detail?roleBizId=${roleBizId}`,
    method: 'get'
  })
}

//作用域切换搜索
export function searchScopeList(data) {
  return request({
    url: '/user/api/sysUser/scope/page',
    method: 'post',
    data: data
  })
}
