import request from '@/utils/request'

// 分页获取新单跟进列表
export function getPolicyFollowList(data) {
  return request({
    url: '/csf/api/policy_follow/list/page/vo',
    method: 'post',
    data: data
  })
}

// 获取预计来佣列表
// /csf/api/commission/list/page/commission_expected
export function getExpectedCommissionList(data) {
  return request({
    url: '/csf/api/policy/list/page/commission_expected',
    method: 'post',
    data: data
  })
}

// 更新至保单库
export function updateToPolicyLib(data) {
  return request({
    url: '/csf/api/policy_follow/addToPolicy',
    method: 'post',
    data: data
  })
}
// 更新新单跟进
export function updatePolicyfollow(data) {
  return request({
    url: '/csf/api/policy_follow/update',
    method: 'post',
    data: data
  })
}
// 获取新单跟进详情
export function getPolicyfollow(policyBizId) {
  return request({
    url: `/csf/api/policy_follow/get/vo?policyBizId=${policyBizId}`,
    method: 'get'
  })
}
// 获取新单跟进状态
export function getPolicyStatus(policyBizId) {
  return request({
    url: `/csf/api/policy_follow/status/list?policyBizId=${policyBizId}`,
    method: 'get'
  })
}
// 新单跟进附件列表
export function getAttachmentList(data) {
  return request({
    url: '/csf/api/policy_follow/attachment/list/page',
    method: 'post',
    data: data
  })
}

// 删除单个新单跟进附件
export function delAttachmentFile(fileId) {
  return request({
    url: '/csf/api/policy_follow/attachment/delete?fileId=' + fileId,
    method: 'delete'
  })
}
// 上传新单跟进附件
export function uploadPolicyfollow(data) {
  return request({
    url: '/csf/api/policy_follow/attachment/upload',
    method: 'post',
    data: data
  })
}
