// src/types/search-form.ts
export type FormFieldType = 
  | 'input'          // 输入框
  | 'textarea'       // 文本域
  | 'select'         // 普通下拉框
  | 'multi-select'   // 多选下拉框
  | 'remote-select'  // 远程搜索下拉框（单选）
  | 'remote-multi-select' // 远程搜索下拉框（多选）
  | 'date'           // 日期选择器
  | 'daterange'      // 日期范围选择器
  | 'datetime'       // 日期时间选择器
  | 'datetimerange'  // 日期时间范围选择器
  | 'cascader'       // 级联选择器
  | 'radio'          // 单选框
  | 'checkbox'       // 复选框
  | 'switch'         // 开关
  | 'number'         // 数字输入框
  | 'password'       // 密码输入框
  | 'custom'         // 自定义组件

export interface FormOption {
  label: string
  value: string | number
  disabled?: boolean
  children?: FormOption[]
  [key: string]: any
}

export interface RemoteSearchConfig {
  type: string
  apiMethod: (params: any) => Promise<any>
  formatResult?: (data: any[]) => FormOption[]
  cacheKey?: string
  debounceDelay?: number
  defaultOptions?: FormOption[]
  params?: Record<string, any>
}

export interface ValidationRule {
  required?: boolean
  message?: string
  trigger?: 'blur' | 'change' | ['blur', 'change']
  validator?: (rule: any, value: any, callback: (error?: Error) => void) => void
  pattern?: RegExp
  min?: number
  max?: number
  len?: number
  type?: 'string' | 'number' | 'boolean' | 'method' | 'regexp' | 'integer' | 'float' | 'array' | 'object' | 'enum' | 'date' | 'url' | 'hex' | 'email'
  enum?: Array<string | number>
  transform?: (value: any) => any
}

export interface FormField {
  // 基础配置
  type: FormFieldType
  field: string
  label: string
  defaultValue?: any
  
  // 显示配置
  placeholder?: string
  width?: string | number
  colSpan?: number // 栅格占据的列数 (1-24)
  hidden?: boolean
  disabled?: boolean
  readonly?: boolean
  clearable?: boolean
  
  // 选项配置（用于select/radio/checkbox等）
  options?: FormOption[]
  optionLabel?: string
  optionValue?: string
  
  // 远程搜索配置
  remoteConfig?: RemoteSearchConfig
  
  // 特殊类型配置
  dateFormat?: string
  rangeSeparator?: string
  startPlaceholder?: string
  endPlaceholder?: string
  showPassword?: boolean
  minRows?: number
  maxRows?: number
  showWordLimit?: boolean
  maxlength?: number
  step?: number
  precision?: number
  
  // 校验规则
  rules?: ValidationRule[]
  
  // 自定义组件
  component?: any
  props?: Record<string, any>
  slots?: Record<string, any>
  
  // 事件
  events?: Record<string, Function>
  
  // 样式
  class?: string
  style?: Record<string, string | number>
}

export interface SearchFormProps {
  modelValue: Record<string, any>
  fields: FormField[]
  labelWidth?: string | number
  labelPosition?: 'left' | 'right' | 'top'
  inline?: boolean
  size?: 'large' | 'default' | 'small'
  disabled?: boolean
  showReset?: boolean
  showSearch?: boolean
  resetText?: string
  searchText?: string
  gutter?: number
  rowClass?: string
  formClass?: string
  
  // 自定义插槽
  prefixSlot?: boolean
  suffixSlot?: boolean
  extraSlot?: boolean
  
  // 搜索和重置前的钩子
  beforeSearch?: (formData: Record<string, any>) => boolean | Promise<boolean>
  beforeReset?: () => boolean | Promise<boolean>
}

export interface SearchFormEmits {
  (e: 'update:modelValue', value: Record<string, any>): void
  (e: 'search', formData: Record<string, any>): void
  (e: 'reset', formData: Record<string, any>): void
  (e: 'change', field: string, value: any): void
  (e: 'field-validate', field: string, isValid: boolean, message?: string): void
}