// src/api/search.ts
import request from '@/utils/request'

// 通用搜索接口
export function commonSearch(params: {
  module: string
  keyword?: string
  pageSize?: number
}) {
  return request({
    url: '/common/search',
    method: 'get',
    params
  })
}

// 特定模块搜索
export function searchCompanies(params: {
  type?: string
  keyword?: string
  pageSize?: number
}) {
  return request({
    url: '/company/search',
    method: 'get',
    params
  })
}

export function searchCommissionTypes(params: {
  keyword?: string
  pageSize?: number
}) {
  return request({
    url: '/commission/type/search',
    method: 'get',
    params
  })
}

export function searchInsurers(params: {
  keyword?: string
  pageSize?: number
}) {
  return request({
    url: '/insurer/search',
    method: 'get',
    params
  })
}

export function searchProducts(params: {
  keyword?: string
  pageSize?: number
}) {
  return request({
    url: '/product/search',
    method: 'get',
    params
  })
}