import request from '@/utils/request'

// 获取保单来佣列表
export function getPolicyCommissionList(data) {
  return request({
    url: '/csf/api/commission/list/page/vo',
    method: 'post',
    data: data
  })
}

// 更新保单来佣信息
export function updatePolicyCommission(data) {
  return request({
    url: '/csf/api/commission/update',
    method: 'post',
    data: data
  })
}

// 生成可出账记录
export function generateCommissionRecord(data) {
  return request({
    url: '/csf/api/commission/generate/fortune',
    method: 'post',
    data: data
  })
}

// 更新保单发佣信息
export function updatePolicyFortune(data) {
  return request({
    url: '/csf/api/fortune/update',
    method: 'post',
    data: data
  })
}

// 获取保单发佣列表

export function getPolicyFortuneList(data) {
  return request({
    url: '/csf/api/fortune/list/page/vo',
    method: 'post',
    data: data
  })
}

// 下载选中的发佣数据

export function downloadPolicyFortune(data) {
  return request({
    url: '/csf/api/fortune/download/raw',
    method: 'post',
    data: data,
    responseType: 'blob'
  })
}

// 生成出账清单
// /csf/api/fortune/download/account
export function downloadPolicyFortuneAccount(data) {
  return request({
    url: '/csf/api/fortune/download/account',
    method: 'post',
    data: data,
    responseType: 'blob'
  })
}

// 按照人的维度，查询出账列表
export function getReferrerFortuneList(data) {
  return request({
    url: '/csf/api/fortune/list/page/fortuneAccount',
    method: 'post',
    data: data
  })
}

// 删除来佣数据
// /csf/api/commission/delete
export function deletePolicyCommission(data) {
  return request({
    url: '/csf/api/commission/delete',
    method: 'post',
    data: data
  })
}

// 更新出账状态
// /csf/api/fortune/update/status
export function updatePolicyFortuneStatus(data) {
  return request({
    url: '/csf/api/fortune/update/status',
    method: 'post',
    data: data
  })
}

// 完成出账
// /csf/api/fortune/complete
export function completePolicyFortune(data) {
  return request({
    url: '/csf/api/fortune/complete/fortuneAccount',
    method: 'post',
    data: data
  })
}

// 获取对账公司
// /csf/api/reconciliation_company/list/page
export function getReconciliationCompanyList(data) {
  return request({
    url: '/csf/api/reconciliation_company/list/page',
    method: 'post',
    data: data
  })
}

// 删除出账
// /csf/api/fortune/delete
export function deletePolicyFortune(data) {
  return request({
    url: '/csf/api/fortune/delete/fortuneAccount',
    method: 'post',
    data: data
  })
}

// 修改出账信息
// /csf/api/fortune/update/fortuneAccount
export function updatePolicyFortuneAccount(data) {
  return request({
    url: '/csf/api/fortune/update/fortuneAccount',
    method: 'post',
    data: data
  })
}

// 新建出账
// /csf/api/fortune/add/fortuneAccount
export function addPolicyFortuneAccount(data) {
  return request({
    url: '/csf/api/fortune/add/fortuneAccount',
    method: 'post',
    data: data
  })
}

// 删除发佣
// /csf/api/fortune/delete/fortuneAccount
export function deletePolicyFortuneAccount(data) {
  return request({
    url: '/csf/api/fortune/delete',
    method: 'post',
    data: data
  })
}

// 新建来佣
// /csf/api/commission/add
export function addPolicyCommission(data) {
  return request({
    url: '/csf/api/commission/add',
    method: 'post',
    data: data
  })
}
// 入账管理的统计数据
export function incomeStatistics(data) {
  return request({
    url: '/csf/api/commission/statistics',
    method: 'post',
    data: data
  })
}
// 出账管理的统计数据
export function billStatistics(data) {
  return request({
    url: '/csf/api/fortune/statistics',
    method: 'post',
    data: data
  })
}
// 出账管理的统计数据
export function salaryStatistics(data) {
  return request({
    url: '/csf/api/fortune/fortuneAccount/statistics',
    method: 'post',
    data: data
  })
}
// 薪资管理修订记录
export function salaryEditRecords(data) {
  return request({
    url: '/csf/api/fortune/editRecords/fortuneAccount',
    method: 'post',
    data: data
  })
}
// 入账管理操作记录
export function incomeEditRecords(data) {
  return request({
    url: '/csf/api/commission/edit/records',
    method: 'post',
    data: data
  })
}
// 入账管理比对记录列表
export function incomeCompareRecords(data) {
  return request({
    url: '/csf/api/commission/compare/records',
    method: 'post',
    data: data
  })
}
// 保单号列表
export function policyData(data) {
  return request({
    url: '/csf/api/CommissionExpected/list/page',
    method: 'post',
    data: data
  })
}

// 应付款管理列表
export function expectedFortuneList(data) {
  return request({
    url: '/csf/api/expectedFortune/list',
    method: 'post',
    data: data
  })
}

// 应收款管理列表
export function receivedFortuneList(data) {
  return request({
    url: '/csf/api/CommissionExpected/queryCommissionExpectedByPage',
    method: 'post',
    data: data
  })
}
// 统计应收数据总金额、总入账金额、待入账金额、已入账比例（已入账金额-总金额）、总保单数
export function commissionExpectedStatistics(data) {
  return request({
    url: '/csf/api/CommissionExpected/statistics',
    method: 'post',
    data: data
  })
}
// 统计计算统计数据 预计发佣金额 HKD、已出账金额 HKD、待出账金额 HKD、总保单数、总保费 HKD
export function expectedFortuneStatistics(data) {
  return request({
    url: '/csf/api/expectedFortune/statistics',
    method: 'post',
    data: data
  })
}
// 入账记录查询
export function commissionEntryRecord(data) {
  return request({
    url: '/csf/api/commission/compare/records',
    method: 'post',
    data: data
  })
}
// 入账操作记录查询
export function commissionEntryEditRecords(data) {
  return request({
    url: '/csf/api/commission/edit/records',
    method: 'post',
    data: data
  })
}
