// key: 'person',代表个人，key: 'company',代表公司
const applicant = [
  // 客户信息 此模块始终展示
  {
    fatherTitle: '客户信息',
    type: 'object',
    key: 'customer',
    showMoudle: true, //模块是否展示
    data: [
      {
        label: '客户类型',
        key: 'customerType',
        customerKey: 'customerType',
        domType: 'Select',
        required: true,
        disabled: false,
        placeholder: '请选择',
        dictType: 'csf_customer_type',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '客户编号',
        key: 'customerNo',
        customerKey: 'customCode',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 200,
        disabled: true,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      }
    ]
  },
  // 基础信息
  {
    fatherTitle: '基础信息',
    type: 'object',
    key: 'person',
    labelPosition: 'top', //标签的位置
    showMoudle: true, //模块是否展示
    // description: '证件信息至少填写一项',
    data: [
      {
        label: '名字-英文',
        key: 'nameEn',
        customerKey: 'firstNamePinyin',
        showEn: true, //是否填写英文
        domType: 'Input',
        inputType: 'text',
        required: true,
        maxLength: 20,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '名字',
        key: 'name',
        customerKey: 'name',
        domType: 'Input',
        inputType: 'text',
        required: true,
        maxLength: 20,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '性别',
        key: 'gender',
        customerKey: 'gender',
        domType: 'Select',
        required: true,
        disabled: false,
        placeholder: '请选择',
        dictType: 'sys_gender',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '证件类型',
        key: 'documentType',
        customerKey: 'idType',
        domType: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'csf_id_type',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '证件号码',
        key: 'idNumber',
        customerKey: 'idCard',
        domType: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 20,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '出生日期',
        key: 'birthday',
        customerKey: 'birthdate',
        domType: 'DatePicker',
        required: false,
        disabled: false,
        placeholder: '请选择',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '年龄',
        key: 'age',
        customerKey: 'age',
        domType: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 20,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '居住地址',
        key: 'residenceAddress',
        customerKey: 'residenceAddress',
        domType: 'arrowRight',
        required: false,
        disabled: false,
        placeholder: '请填写',
        show: true,
        drawerType: 'address',
        residenceAddress: {},
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '通讯地址',
        commonKey: true, //是否是公共字段
        key: 'txAddress',
        // customerKey: 'mailingAddress',
        domType: 'arrowRight',
        required: false,
        disabled: false,
        placeholder: '请填写',
        show: true,
        drawerType: 'address',
        txAddress: {},
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '移动电话',
        key: 'mobile',
        customerKey: 'phone',
        customerCode: 'areaCode',
        domType: 'arrowRight',
        required: true,
        disabled: false,
        placeholder: '请填写',
        show: true,
        drawerType: 'phone',
        mobile: {}, //带有区号得电话一定要有一个和key一样得对象用于收集区号和号码
        code: 'mobileCode',
        maxLength: 20,
        labelPosition: 'top', //标签的位置
        labelWidth: '180px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '邮箱',
        key: 'email',
        customerKey: 'email',
        domType: 'Input',
        inputType: 'text',
        maxLength: 30,
        required: false,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '公司名称',
        key: 'companyName',
        customerKey: 'companyName',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '公司地址',
        key: 'companyAddress',
        customerKey: 'companyAddress',
        domType: 'arrowRight',
        required: false,
        disabled: false,
        placeholder: '请填写',
        show: true,
        drawerType: 'address',
        companyAddress: {},
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '行业',
        key: 'industry',
        customerKey: 'companyType',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '职位',
        key: 'position',
        customerKey: 'position',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },

      {
        label: '风险偏好',
        key: 'riskAppetite',
        domType: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'csf_ap_risk',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: 'VIP',
        key: 'isVip',
        domType: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'sys_no_yes',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '备注',
        key: 'vipRemark',
        domType: 'Input',
        inputType: 'textarea',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: false,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 24, //栅格布局份数
        lg: 24 //栅格布局份数
      }
    ]
  },
  // 个人信息
  {
    fatherTitle: '个人信息',
    type: 'object',
    key: 'person',
    showMoudle: true, //模块是否展示
    // description: '证件信息至少填写一项',
    data: [
      {
        label: '称谓',
        key: 'appellation',
        customerKey: 'title',
        domType: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'csf_customer_title',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '是否吸烟',
        key: 'smokingAllowed',
        customerKey: 'smoke',
        domType: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'sys_no_yes',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '吸烟量(支/天)',
        key: 'smokingVolume',
        customerKey: 'smokeQuantity',
        domType: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: false,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '出生地(省市)',
        key: 'birthplace',
        customerKey: 'birthplace',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '国籍',
        key: 'nationality',
        customerKey: 'countryName',
        domType: 'arrowRight',
        required: true,
        disabled: false,
        placeholder: '请填写',
        show: true,
        drawerType: 'country',
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '身高',
        key: 'height',
        domType: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入身高(cm)',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '体重',
        key: 'weight',
        domType: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入身高(kg)',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },

      {
        label: 'BMI',
        key: 'bmi',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '平均每月收入',
        key: 'monthIncome',
        domType: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入平均每月收入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '平均每月支出',
        key: 'monthExpenditure',
        domType: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入平均每月支出',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '受雇于现职年期',
        key: 'currentTenure',
        domType: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '总流动资产',
        key: 'totalCurrentAssets',
        domType: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入平均每月支出',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '总负债额',
        key: 'totalDebt',
        domType: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '受供养人数目',
        key: 'dependentsNum',
        domType: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '婚姻状况',
        key: 'maritalStatus',
        customerKey: 'marriage',
        domType: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'csf_marriage',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '教育程度',
        key: 'educationLevel',
        customerKey: 'education',
        domType: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'csf_education',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '现时每月收入',
        key: 'currentMonthlyIncome',
        customerKey: 'salary',
        domType: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '总工作年期',
        key: 'totalWorkingYears',
        customerKey: 'workYear',
        domType: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入平均每月支出',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '公司电话',
        key: 'companyMobile',
        commonKey: true,
        customerKey: 'companyTelephone',
        customerCode: 'companyAreaCode',
        domType: 'arrowRight',
        required: false,
        disabled: false,
        placeholder: '请填写',
        show: true,
        drawerType: 'phone',
        companyMobile: {}, //带有区号得电话一定要有一个和key一样得对象用于收集区号和号码
        code: 'companyMobileCode',
        maxLength: 20,
        labelPosition: 'top', //标签的位置
        labelWidth: '180px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '固定电话',
        key: 'landline',
        customerKey: 'fixedPhone',
        domType: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '其他电话',
        commonKey: true, //是否是公共字段
        key: 'otherMobile',
        domType: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '过往一年是否所属国家以外地区居住超过182日',
        key: 'isExceed',
        domType: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'sys_no_yes',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '是否拥有其他国家公民身份（如美国、日本等）',
        key: 'isOtherCountry',
        domType: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'sys_no_yes',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '是否接受推广信息',
        commonKey: true, //是否是公共字段
        key: 'isPromotion',
        domType: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'sys_no_yes',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '投保人邮政编码',
        key: 'postalCode',
        domType: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入平均每月支出',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      }
    ]
  },
  //其他信息
  {
    fatherTitle: '其他信息',
    type: 'object',
    key: 'person',
    showMoudle: true, //模块是否展示
    data: [
      {
        label: '旅行',
        key: 'travel',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '运动',
        key: 'exercise',
        domType: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'csf_ap_exercise',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '游戏',
        key: 'game',
        domType: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'csf_ap_game',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '电影/戏剧',
        key: 'movieDrama',
        domType: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'csf_ap_movie',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },

      {
        label: '美食',
        key: 'delicacy',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      }
    ]
  },
  // 公司信息
  {
    fatherTitle: '公司信息',
    type: 'object',
    key: 'company',
    labelPosition: 'top', //标签的位置
    showMoudle: false, //模块是否展示
    data: [
      {
        label: '公司名称',
        key: 'companyName',
        customerKey: '',
        domType: 'Input',
        inputType: 'text',
        required: true,
        maxLength: 20,
        disabled: false,
        placeholder: '请输入',
        show: true,
        commonKey: true, //是否是公共字段
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '公司名称（英文）',
        key: 'companyNameEn',
        customerKey: 'companyNameEn',
        showEn: true, //是否填写英文
        domType: 'Input',
        inputType: 'text',
        required: true,
        maxLength: 20,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '公司商业登记号码',
        key: 'companyBusinessNo',
        customerKey: 'companyBusinessNo',
        domType: 'Input',
        inputType: 'text',
        required: true,
        maxLength: 20,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '公司注册日期',
        key: 'companyRegisterTime',
        customerKey: '',
        domType: 'DatePicker',
        required: true,
        disabled: false,
        placeholder: '请选择',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '公司电话',
        commonKey: true, //是否是公共字段
        key: 'companyMobile',
        customerKey: '',
        domType: 'arrowRight',
        required: true,
        disabled: false,
        placeholder: '请填写',
        show: true,
        drawerType: 'phone',
        companyMobile: {}, //带有区号得电话一定要有一个和key一样得对象用于收集区号和号码
        code: 'companyMobileCode',
        maxLength: 20,
        labelPosition: 'top', //标签的位置
        labelWidth: '180px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '公司注册地区',
        key: 'companyRegisterRegion',
        customerKey: '',
        domType: 'Select',
        required: true,
        disabled: false,
        placeholder: '请选择',
        dictType: 'csf_ap_registration',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '公司邮箱',
        key: 'companyEmail',
        customerKey: '',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 20,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '公司登记地址',
        key: 'companyEnterAddress',
        customerKey: '',
        domType: 'arrowRight',
        required: false,
        disabled: false,
        placeholder: '请填写',
        show: true,
        drawerType: 'address',
        companyEnterAddress: {},
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '通讯地址',
        commonKey: true, //是否是公共字段
        key: 'txAddress',
        customerKey: '',
        domType: 'arrowRight',
        required: false,
        disabled: false,
        placeholder: '请填写',
        show: true,
        drawerType: 'address',
        txAddress: {},
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '授权代表姓名中文-名字',
        key: 'authNameCn',
        customerKey: '',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 20,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '授权代表姓名英文-名字',
        key: 'authNameEn',
        customerKey: '',
        showEn: true, //是否填写英文
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 20,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '授权代表职称',
        key: 'authProfessional',
        customerKey: '',
        domType: 'Input',
        inputType: 'text',
        required: false,
        maxLength: 20,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '授权代表电话',
        key: 'authMobile',
        customerKey: '',
        domType: 'arrowRight',
        required: false,
        disabled: false,
        placeholder: '请填写',
        show: true,
        drawerType: 'phone',
        authMobile: {}, //带有区号得电话一定要有一个和key一样得对象用于收集区号和号码
        code: 'authMobileCode',
        maxLength: 20,
        labelPosition: 'top', //标签的位置
        labelWidth: '180px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '其他电话',
        commonKey: true, //是否是公共字段
        key: 'otherMobile',
        customerKey: '',
        domType: 'Input',
        inputType: 'number',
        required: false,
        maxLength: 300,
        disabled: false,
        placeholder: '请输入',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      },
      {
        label: '是否接受推广信息',
        commonKey: true, //是否是公共字段
        key: 'isPromotion',
        customerKey: '',
        domType: 'Select',
        required: false,
        disabled: false,
        placeholder: '请选择',
        dictType: 'sys_no_yes',
        show: true,
        labelPosition: 'top', //标签的位置
        labelWidth: '120px', //标签宽度
        sm: 12, //栅格布局份数
        lg: 8 //栅格布局份数
      }
    ]
  }
]
export default applicant
