import request from '@/utils/request'

// 分页获取新单跟进列表
export function getPolicyFollowList(data) {
  return request({
    url: '/csf/api/policy_follow/list/page/vo',
    method: 'post',
    data: data
  })
}

// 获取预计来佣列表
// /csf/api/commission/list/page/commission_expected
export function getExpectedCommissionList(data) {
  return request({
    url: '/csf/api/policy/list/page/commission_expected',
    method: 'post',
    data: data
  })
}

// 更新至保单库
export function updateToPolicyLib(data) {
  return request({
    url: '/csf/api/policy_follow/addToPolicy',
    method: 'post',
    data: data
  })
}
// 更新新单跟进
export function updatePolicyfollow(data) {
  return request({
    url: '/csf/api/policy_follow/update',
    method: 'post',
    data: data
  })
}
// 获取新单跟进详情
export function getPolicyfollow(policyBizId) {
  return request({
    url: `/csf/api/policy_follow/get/vo?policyBizId=${policyBizId}`,
    method: 'get'
  })
}
// 获取新单跟进详情
export function getPolicyInfo(policyBizId) {
  return request({
    url: `/csf/api/policy_follow/detail/${policyBizId}`,
    method: 'get'
  })
}
// 获取新单跟进状态
export function getPolicyStatus(policyBizId) {
  return request({
    url: `/csf/api/policy_follow/status/list?policyBizId=${policyBizId}`,
    method: 'get'
  })
}
// 新单跟进附件列表
export function getAttachmentList(data) {
  return request({
    url: '/csf/api/policy_follow/attachment/list/page',
    method: 'post',
    data: data
  })
}

// 删除单个新单跟进附件
export function delAttachmentFile(fileId) {
  return request({
    url: '/csf/api/policy_follow/attachment/delete?fileId=' + fileId,
    method: 'delete'
  })
}
// 上传新单跟进附件
export function uploadPolicyfollow(data) {
  return request({
    url: '/csf/api/policy_follow/attachment/upload',
    method: 'post',
    data: data
  })
}
// 新单跟进详情中的产品计划提交
export function updatePolicyProduct(data) {
  return request({
    url: '/csf/api/policy/update',
    method: 'post',
    data: data
  })
}
// 删除附加险
export function delPolicyAdditional(id) {
  return request({
    url: '/csf/api/policy_additional/delete?id=' + id,
    method: 'delete'
  })
}
// 新单跟进详情中的投保人提交
export function updatePolicyholder(data) {
  return request({
    url: '/csf/api/policy/update_policyholder',
    method: 'post',
    data: data
  })
}
// 新单跟进详情中的受保人提交
export function updatePolicyInsurant(data) {
  return request({
    url: '/csf/api/policy/update_policy_insurant',
    method: 'post',
    data: data
  })
}
// 新单跟进详情中的第二持有人提交
export function updatePolicySecondHolder(data) {
  return request({
    url: '/csf/api/policy/update_policy_second_holder',
    method: 'post',
    data: data
  })
}
// 新单跟进详情中的受益人提交
export function updatePolicyBeneficiary(data) {
  return request({
    url: '/csf/api/policy_beneficiary/update/list',
    method: 'post',
    data: data
  })
}
// 删除单个受益人
export function delPolicyBeneficiary(policyBeneficiaryBizId) {
  return request({
    url: '/csf/api/policy_beneficiary/delete?policyBeneficiaryBizId=' + policyBeneficiaryBizId,
    method: 'delete'
  })
}
